/*------------------------------------------------------------------------------*
 *	File Name: 	NLParams.h														*
 *	Purpose:	Shared between OC and VC										*
 *																				*
 *																				*
 *	Author:		ML																*
 *  Creation:	5/3/2008 														*
 *  	Copyright (c) Microcal Software Inc. 2008, 2009, 2010, 2011, 2012, 2013	*
 *																				*
 *	Modification log                                                        	*
 *	Sim 09-10-2008 NLFIT_LABTALK_TREE_ACCESS									*
 *	Folger 11/04/08 QA80-12509 v8.0965 SUPPORT_BOTH_PEAKS_SORTING_AND_REORDERING_FOR_MULTIPLE_PEAKS_FITTING
 *	Folger 12/08/08 QA80-12730 v8.0983b SUPPORT_GET_TOTAL_GROUP_INDICES_AND_GET_PARAM_INDICES_BY_GROUP_INDEX
 *	Folger 12/16/08 QA80-10499 v8.0987b SUUPORT_MULTI_SETS_PARAM_MANAGER_INITIALIZED_BY_OBJECT_COPY
 *	Hong 01/23/09 MORE_PRECISE_BOUND_CLEAR_AND_RESET_CONTEXT_MENU				*
 *	Folger 02/09/09 QA80-13085 MORE_CLEAR_WAY_TO_INDICATE_MISSING_PARAMETERS_INSTEAD_OF_DISABLE_ITERATION
 *	Folger 03/17/09 QA80-13290 PARAMETERS_GRID_SUPPORT_COPY_AND_PASTE_ALL_VALUES_DEPEND_ON_BASED_NAME
 *	Folger 04/03/09 QA80-13408 SUPPORT_GET_COLUMN_NUMERIC_VALUES_WITH_FULL_PRECISION_FROM_NLPARAM_MANAGER
 *	Folger 04/27/09 2D_REPLICA_PARAMETERS_INITIALIZATION_FOR_NANOSIZER			*
 *	Folger 05/06/09 QA80-13544 IMPROVE_PA_SPEED_WHEN_GO_FROM_FIND_PEAK_TO_FIT_PEAK
 *	Folger 05/12/09 NANOSIZER_FITTING_BASED_SUPPORT								*
 *	Folger 06/18/09 CENTRALIZE_CODE_ABOUT_GETTING_PEAK_FUNC_PARAM_INDICES		*
 *	Folger 07/16/09 NANOSIZER_FAILS_TO_REPORT_PARAMETER_BOUNDS_FROM_2ND_PEAK	*
 *	Kyle 08/06/2009 QA80-14077 ADD_UNIT_FOR_PARAMETER_SETTINGS					*
 *	Folger 07/08/10 ORG-486 PEKA_AMPLITUDE_NEEDED_IN_NLFIT						*
 *	Folger 07/12/10 ORG-515-P1 COPY_PASTE_WHOLE_COLUMN_IN_NLFIT_SHOULD_ONLY_HANDLE_VISIBLE
 *------------------------------------------------------------------------------*/

#ifndef		__NLPARAMS_H__
#define		__NLPARAMS_H__

/////////////////////////////////////////
// OC/VC shared

/////////////////////////////////////////////////////////////////
//
/////////////////////////////////////////////////////////////////
enum NLPMGRTYPE {
	NLPMGRTYPE_SINGLE_SET_NO_REPLICAS						= 1,
	NLPMGRTYPE_SINGLE_SET_SINGLE_FUNCTION_MULTIPEAKS,
	NLPMGRTYPE_SINGLE_SET_MULTIPLE_FUNCTIONS_MULTIPEAKS,
	NLPMGRTYPE_MULTIPLE_SETS,
};


enum NLPARAMGRIDCOLTYPE {
	NLPARAMGRIDCOLTYPE_PEAK_NO						= 0,	// set index, 1-offset				
	NLPARAMGRIDCOLTYPE_FUNC_NAME,
	NLPARAMGRIDCOLTYPE_NAME,
	NLPARAMGRIDCOLTYPE_UNIT,														///Kyle 08/06/2009 QA80-14077 ADD_UNIT_FOR_PARAMETER_SETTINGS
	NLPARAMGRIDCOLTYPE_MEANING,
	NLPARAMGRIDCOLTYPE_SHARE,
	NLPARAMGRIDCOLTYPE_FIXED,
	NLPARAMGRIDCOLTYPE_VALUE,
	NLPARAMGRIDCOLTYPE_ERROR,
	NLPARAMGRIDCOLTYPE_DEPENDENCY,
	NLPARAMGRIDCOLTYPE_LCL,
	NLPARAMGRIDCOLTYPE_UCL,
	NLPARAMGRIDCOLTYPE_SD,			// display significant digits
	NLPARAMGRIDCOLTYPE_LB,			// bound, lower limit
	NLPARAMGRIDCOLTYPE_LB_CONTROL,	// operator for lower bound
	NLPARAMGRIDCOLTYPE_NAME_DUP,
	NLPARAMGRIDCOLTYPE_UB_CONTROL,
	NLPARAMGRIDCOLTYPE_UB,
	// Many more need to be added here.
	///------ Folger 07/08/10 ORG-486 PEKA_AMPLITUDE_NEEDED_IN_NLFIT
	NLPARAMGRIDCOLTYPE_PEAK_ATTRIBUTE,
	///------ End PEKA_AMPLITUDE_NEEDED_IN_NLFIT

	NLPARAMGRIDCOLTYPE_TOTAL,

	///---Sim 09-10-2008 NLFIT_LABTALK_TREE_ACCESS
	// The following are not assigned to GUI column	index
	// MUST make them follow by NLPARAMGRIDCOLTYPE_TOTAL
	NLPARAMGRIDCOLTYPE_LB_ENABLE,
	NLPARAMGRIDCOLTYPE_LB_EXCLUSIVE,
	NLPARAMGRIDCOLTYPE_UB_ENABLE,
	NLPARAMGRIDCOLTYPE_UB_EXCLUSIVE,
	///---END NLFIT_LABTALK_TREE_ACCESS

	NLPARAMGRIDCOLTYPE_DERIVED_NAME,
	NLPARAMGRIDCOLTYPE_DERIVED_UNIT,								///Kyle 08/06/2009 QA80-14077 ADD_UNIT_FOR_PARAMETER_SETTINGS
	NLPARAMGRIDCOLTYPE_DERIVED_VALUE,
};
enum NLDLGPART
{
	NLDLGPART_SETTINGS_ADVANCED					= 0x00020000,	//	"Advanced" Settings panel (needed for replicas)
		
	NLDLGPART_PARAMETERS_BOUNDS_GRID			= 0x00040000,	//	"Bounds" tab/grid
	NLDLGPART_PARAMETERS_GRID					= 0x00080000,	//	"Parameters" tab/grid
	
	NLDLGPART_FIT_FUNC_DISPLAY					= 0x00100000,	//	"Formula", "Sample Curve", "Function File", "Code" tabs.
	
	NLDLGPART_FITCURVE_DATA						= 0x00200000,	//	Data used for fitting plots (NLFCurves class generates them):
	//		1. If fitting from graph: fit data for plots on source graph
	//		2. If fitting from worksheet: fit data for plots on Fit Curve tab of the dlg.
	//		3. Fit data for residual plots on Residual tab of the dlg.
	
	NLDLGPART_FIT_FUNC_BTNS						= 0x00400000,	// "Create/Edit Fitting Functions", "Save"
	NLDLGPART_FIT_CONTROL_BTNS					= 0x00800000,	// "Initialize Parameters", "Simplex", "Calculate chi-sqr", "1 Iteration", "Fit till converged", "Fit"
	/// Hong 20/05/08 v8.0867 CLEAN_UPDATE_EVENTS_TO_ONE_FUNCTION
	NLDLGPART_FIT_FUNC_CHECKBOX					= 0x01000000,	// "Enable Parameter Initilizatioin", "Enable Constraint"
	/// end CLEAN_UPDATE_EVENTS_TO_ONE_FUNCTION

	NLDLGPART_FDF_SETTINGS						= 0x02000000,
};
// enum
// {
// 	PARAMETERS_SHARING_DO_BACKUP,
// 	PARAMETERS_SHARING_DO_RESTORE,
// 	PARAMETERS_SHARING_CLEAN_BACKUP,
// };

enum NLPARAMETERSETTINGS
{
	NLPARAMETERSETTINGS_VALUE					= 0x00000001,
	NLPARAMETERSETTINGS_SHARED					= 0x00000002,
	NLPARAMETERSETTINGS_NAME					= 0x00000004,
	NLPARAMETERSETTINGS_MEANING					= 0x00000008,
	/// Hong 01/23/09 MORE_PRECISE_BOUND_CLEAR_AND_RESET_CONTEXT_MENU
	NLPARAMETERSETTINGS_FIXED					= 0x00000010,
	NLPARAMETERSETTINGS_SD						= 0x00000020, // display significant digits
	/// end MORE_PRECISE_BOUND_CLEAR_AND_RESET_CONTEXT_MENU
	NLPARAMETERSETTINGS_UNIT					= 0x00000040,		///Kyle 08/06/2009 QA80-14077 ADD_UNIT_FOR_PARAMETER_SETTINGS
};

enum NLFITDIRTY
{
	NLFITDIRTY_FUNCTION							= 0x00020000,
	NLFITDIRTY_PARAMETERS						= 0x00040000,
};

typedef struct tagParameterRow
{
	int				nShared;
	bool			bFixed;
	double			rValue;
	double			rLBValue;
	double			rUBValue;
	int				nLBControl;
	int				nUBControl;
	int				nSignDigits;
}ParameterRow;

enum
{
	NLPARAMETER_BOUNDS_SET_BY_CONSTANT,
	NLPARAMETER_BOUNDS_SET_BY_RELATIVE_OFFSET,
	NLPARAMETER_BOUNDS_SET_BY_ABSOLUTE_OFFSET,
};

enum NLPARAMETERSORTING
{
	NLPARAMETERSORTING_BY_CENTER,
	NLPARAMETERSORTING_BY_CENTER2,
	NLPARAMETERSORTING_BY_WIDTH,
	NLPARAMETERSORTING_BY_WIDTH2,
	NLPARAMETERSORTING_BY_AMPLITUDE,
};

///------ Folger 06/18/09 CENTRALIZE_CODE_ABOUT_GETTING_PEAK_FUNC_PARAM_INDICES
enum NLPARAMETERGETTING
{
	NLPARAMETERGETTING_BY_CENTER		= NLPARAMETERSORTING_BY_CENTER,
	NLPARAMETERGETTING_BY_CENTER2		= NLPARAMETERSORTING_BY_CENTER2,
	NLPARAMETERGETTING_BY_WIDTH			= NLPARAMETERSORTING_BY_WIDTH,
	NLPARAMETERGETTING_BY_WIDTH2		= NLPARAMETERSORTING_BY_WIDTH2,
	NLPARAMETERGETTING_BY_AMPLITUDE		= NLPARAMETERSORTING_BY_AMPLITUDE,
};
///------ End CENTRALIZE_CODE_ABOUT_GETTING_PEAK_FUNC_PARAM_INDICES

///------ Folger 05/12/09 NANOSIZER_FITTING_BASED_SUPPORT
enum
{
	NLPARAMMNGRCNTRL_NANOSIZER			= 0x00000001,
};
///------ End NANOSIZER_FITTING_BASED_SUPPORT

#define STR_OFFSET_PEAK_INFO		_OL("Offset / Baseline")
#define E_STR_OFFSET_PEAK_INFO		_LE("Offset / Baseline")
#define STR_X_CENTER_PEAK_INFO		_OL("X Center")
#define E_STR_X_CENTER_PEAK_INFO	_LE("X Center")
#define STR_X_WIDTH_PEAK_INFO		_OL("X Width")
#define E_STR_X_WIDTH_PEAK_INFO		_LE("X Width")
#define STR_Y_CENTER_PEAK_INFO		_OL("Y Center")
#define E_STR_Y_CENTER_PEAK_INFO	_LE("Y Center")
#define STR_Y_WIDTH_PEAK_INFO		_OL("Y Width")
#define E_STR_Y_WIDTH_PEAK_INFO		_LE("Y Width")
#define STR_AMPLITUDE_PEAK_INFO		_OL("Amplitude / Area")
#define E_STR_AMPLITUDE_PEAK_INFO	_LE("Amplitude / Area")

//////////////////////////////////////////////////////
//////////////////////////////////////////////////////
#ifndef		_MSC_VER		// !VC=OC

class NLParametersManager
{
public:

	/**
		It initializes the manager for the given fitting type.
	*/
	///------ Folger 05/12/09 NANOSIZER_FITTING_BASED_SUPPORT
	//void	Initialize(NLPMGRTYPE nType);
	void	Initialize(NLPMGRTYPE nType, DWORD dwCntrl = 0);
	///------ End NANOSIZER_FITTING_BASED_SUPPORT

	NLPMGRTYPE		GetType();

	/**
		Get parameter settings string array for GUI display according to column type, will NOT trim shared
		return size of arrValues.
	*/
	int		GetColumn(NLPARAMGRIDCOLTYPE nColType, StringArray &arrValues, BOOL bGetSorted = TRUE);

	///------ Folger 04/03/09 QA80-13408 SUPPORT_GET_COLUMN_NUMERIC_VALUES_WITH_FULL_PRECISION_FROM_NLPARAM_MANAGER
	int		GetNumericColumn(NLPARAMGRIDCOLTYPE nColType, vectorbase& vValues);
	///------ End SUPPORT_GET_COLUMN_NUMERIC_VALUES_WITH_FULL_PRECISION_FROM_NLPARAM_MANAGER

  	//int		SetOneFunc(LPCSTR lpcszFunc, LPCSTR lpcszFuncFile, int nNumParams, int nIndex = -1);
	int		SetOneFunc(LPCSTR lpcszFuncFile, TreeNode& trFDF = NULL, LPCSTR lpcszFunc = NULL, LPCSTR lpcszCate = NULL, int nIndex = -1);
	/**
		Set one parameter settings and value by function index and parameter index in function
	Parameter:
		nFuncIndex = [input]function index
		nSetIndex = [input]dataset index
		nIndex = [input]parameter index in function for single set case, offset by GetPeakParameterOffset(nFunc)
				or index in dataset for multiple sets
		... parameter value and other settings
	Return:
		0 if no error, otherewise negative error code returned
	*/
	///Kyle 08/06/2009 QA80-14077 ADD_UNIT_FOR_PARAMETER_SETTINGS
 	//int		SetOneFuncParam(int nFuncIndex, int nSetIndex, int nIndex, double *prValue = NULL, bool *pbFixed = NULL, int *pnShared = NULL,
  	//			/*LPCSTR lpcszName = NULL, */LPCSTR lpcszMeaning = NULL, int *pnSignDigits = NULL, bool *pbLBEnable = NULL, bool *pbLBExclusive = NULL, double *prLB = NULL, bool *pbUBEnable = NULL, bool *pbUBExclusive = NULL, double *prUB = NULL);
 	int		SetOneFuncParam(int nFuncIndex, int nSetIndex, int nIndex, double *prValue = NULL, bool *pbFixed = NULL, int *pnShared = NULL,
  				LPCSTR lpcszUnit = NULL, LPCSTR lpcszMeaning = NULL, int *pnSignDigits = NULL, bool *pbLBEnable = NULL, bool *pbLBExclusive = NULL, double *prLB = NULL, bool *pbUBEnable = NULL, bool *pbUBExclusive = NULL, double *prUB = NULL);
	///End ADD_UNIT_FOR_PARAMETER_SETTINGS

	/**
		Get parameter values by dataset index or peak index, will NOT trim shared
	Parameters:
		vParamValues = [output]
		nDataIndex = [input]
		nPeakIndex = [input]
		bIgnoreOffset = [input]if TRUE then ignore peak parameter offset(y0, z0, etec), that means when get peak parameter values from 2nd peak, or larger,
						total number of values is less than total number of function parameters.
	Return:
		size of vParamValues if successful, otherwise negative error code
	*/
	int		GetParamValues(vector &vParamValues, int nDatasetIndex = 0, int nPeakIndex = 0, bool bIgnoreOffset = false);


	/**
		For every parameter return whether to show/hide row. The size is the same as the numner of parameters.		
	Parameters:
		vbShow=[output]
	Return:
		Size of vbShow
	*/
	int		GetRowsShow(vector<bool> &vbShow);

	/**
		Returns into the array the starting row index of every logical group. One logical group are all the parameters of
		one set is multiple sets, or of one peak if multiple peaks.
		vnBegin[0] indicates the beginning of the 2nd group, so vnBegin.GetSize() == nNumGroups - 1
	Parameters:
		vnBegin=[output]
	Return:
		Size of vnBegin if success
	*/
	int		GetGroupingRowsBegin(vector<int> &vnBegin);

	/**
		return combination of NLDLGPART
	*/
	int		OnEdit(NLPARAMGRIDCOLTYPE nEditColType, int nParamRow, LPCSTR lpcszNewValue);

	///---Sim 09-10-2008 NLFIT_LABTALK_TREE_ACCESS
	///**
		//Labtalk tree access
	//Parameters:
		//lpcszName = [input] labtalk tree name
		//dwOption = [input] optional access control
	//*/
	//int		LinkLabtalkTree(LPCSTR lpcszName, DWORD dwOption = 0);
	
	/**$
	*/
	BOOL	LabTalkTreeAccess(LPSTR lpVar, LPSTR lpArg, LPVOID lpValue, WORD msg, DWORD dwOption = 0);
	
	/**$
	*/
	BOOL	MakeLabTalkTree(TreeNode& trLT, DWORD dwOption = 0);
	///---END NLFIT_LABTALK_TREE_ACCESS

	/**
		Update NLParametersManager after NLFit::Fit is done
	*/
	int		OnAfterFit();

	/**
		Get FDF tree for one specific function
	Parameters:
		trFDF = [output]FDF tree by index
		nFuncIndex = [input]Fit function index, always 0 for single function, nIndex > 0 only for multiple functions (PA)
		bClone = [input]if TRUE, trFDF will be a copy of FDF tree which kept in NLParamMngr.
	*/
	///------ Folger 05/06/09 QA80-13544 IMPROVE_PA_SPEED_WHEN_GO_FROM_FIND_PEAK_TO_FIT_PEAK
	//int		GetFDFTree(TreeNode &trFDF, int nFuncIndex = 0);
	int		GetFDFTree(TreeNode &trFDF, int nFuncIndex = 0, BOOL bClone = TRUE);
	///------ End IMPROVE_PA_SPEED_WHEN_GO_FROM_FIND_PEAK_TO_FIT_PEAK

	/**
		Set FDF tree into NLParameterManager, trFDF == NULL means reset
	Parameters:
		trFDF = [input]
	*/
	int		SetFDFTree(const TreeNode &trFDF);

	/**
		FDF tree dirty means it has been changed and is different from which kept in FDF file.
		Once it's dirty, after save FDF, SetFDFTree(NULL) should be called, and it will not be dirty any more.
	*/
	BOOL	IsFDFTreeDirty();

	/**
		If there exists missing-value in parameter values, FALSE will be returned
	*/
	///------ Folger 02/09/09 QA80-13085 MORE_CLEAR_WAY_TO_INDICATE_MISSING_PARAMETERS_INSTEAD_OF_DISABLE_ITERATION
	//BOOL	IsParametersReady();
	BOOL	IsParametersReady(vector<int>* pvnMissingParams = NULL);
	///------ End MORE_CLEAR_WAY_TO_INDICATE_MISSING_PARAMETERS_INSTEAD_OF_DISABLE_ITERATION

	BOOL	GetFuncName(string &strName, string *pstrCate = NULL, int nFunc = 0);

	/**
		Get all patameters in function, not in FDF.
		For example, fitting with Gauss of replica number 1, then return 7, but not 4.
		For PA, parameter offset for each peak is trimmed, that means "y0" is not counted from second peak
	*/
	int		GetNumParamsInFunc(int nFunc = 0);

	/**
	Parameters:
		nNumMultiplicity=[output]
		nFunc=[input]function index for getting function multiplicity, -1 means get number of all peaks
	*/
	BOOL	GetNumMultiplicity(int &nNumMultiplicity, int nFunc = -1);

	/**
		Set multiplicity is not legal for NLPMGRTYPE_SINGLE_SET_NO_REPLICAS
		After set multiplicity, 
		1. for NLPMGRTYPE_SINGLE_SET_SINGLE_FUNCTION_MULTIPEAKS, need to set all parameters
		2. for NLPMGRTYPE_SINGLE_SET_MULTIPLE_FUNCTIONS_MULTIPEAKS, need to set all functions and parameters in each function
	*/
	BOOL	SetNumMultiplicity(int nNumMultiplicity);

	///------ Folger 04/27/09 2D_REPLICA_PARAMETERS_INITIALIZATION_FOR_NANOSIZER
	//int		SetReplicasInitialParameters(vector &vCenters, vector &vWidths, vector &vHeights, double dBaseline, vector &vDefaultParams);
	int		SetReplicasInitialParameters(vector &vCenters, vector &vWidths, vector &vHeights, double dBaseline, vector &vDefaultParams, vector* pvYCenters = NULL, vector* pvYWidths = NULL, vector<int>* pvnIndices = NULL);
	///------ End 2D_REPLICA_PARAMETERS_INITIALIZATION_FOR_NANOSIZER

	BOOL	DuplicateReplicaParameterSettings(DWORD dwSettingsToSkip = 0);

	BOOL	DuplicateDatasetParameterSettings(int nDesSetIndex, int nSrcSetIndex, DWORD dwSettingsToSkip = 0);

	/**
	return:
		number of dependent/independent variable, any error (like fit function not set ) that 0 returned
	*/
	int		GetNumVariables(BOOL bDependent, StringArray *parrNames = NULL);

	/**
	Parameters:
		bParseControl=[input]true to parse vnBoundsControl into vbBoundsEnable and vbBoundsExclusive,
							false to construct vnBoundsControl from vbBoundsEnable and vbBoundsExclusive
	*/
	void	ConvertBoundsControl(BOOL bParseControl, vector<int> &vnBoundsControl, vector<bool> &vbBoundsEnable, vector<bool> &vbBoundsExclusive);

	/**
	Return :
		number of fit function, if fit function not set then 0 return
	*/
	int		GetNumFitFunctions();

	int		GetFuncIndex(int nPeakIndex);

	/**
		This function only works for NLPMGRTYPE_SINGLE_SET_MULTIPLE_FUNCTIONS_MULTIPEAKS, like PA
	Parameters:
		nFuncIndex=[input]function index to remove, -1 means remove all
	*/
	BOOL	RemovePeak(int nPeakIndex);

	/**
		Get parameter offset for each function, works in PA only
	*/
	int		GetFunctionParameterOffset(int nFuncIndex);
	
	///------ Folger 07/16/09 NANOSIZER_FAILS_TO_REPORT_PARAMETER_BOUNDS_FROM_2ND_PEAK
	/**
		Get parameter offset for each peak, for both PA and Replica case
	*/
	int		GetPeakParameterOffset(int nPeakIndex);
	///------ End NANOSIZER_FAILS_TO_REPORT_PARAMETER_BOUNDS_FROM_2ND_PEAK

	/**
		Set or Get parameter settings from Parameter tree which is stored in operation tree or theme tree
		dwSettingsToSkip is combination of NLPARAMETERSETTINGS
	*/
	BOOL	SetParamSettings(const TreeNode &trOperationParams, DWORD dwSettingsToSkip = 0, bool bDuplicateLastSetValues = false);
	BOOL	GetParamSettings(TreeNode &trOperationParams);

	/**
		This function only works for multiple functions peak fitting, like PA
		trFuncsAndParams is the same structure like tree in NLFit::SetFunctionsMultipeakFitting :

		trFuncsAndParams
			|
			|-Peaks
				|
				|-Peak1
				|	|-Function
				|	|	|-FuncName
				|	|	|-File
				|	|	|-FullPath
				|	|-Parameters
				|		|-y0
				|		  |-Value
				|		  |-Shared
				|		  |-Fixed
				|		  |-LowerBounds
				|		  |-UpperBounds
				|		  |-LowerBoundsExclusive
				|		  |-UpperBoundsExclusive
				|		|-xc
				|		...
				|
				|-Peak2
				...
	*/
	BOOL	SetFuncsAndParamsMultiFuncsPeakFitting(const TreeNode& trFuncsAndParams);
	BOOL	GetFuncsAndParamsMultiFuncsPeakFitting(TreeNode& trFuncsAndParams);

	/// should be done in OC by Hong
	//BOOL	ParametersSharingHelper(int nOp = PARAMETERS_SHARING_DO_BACKUP);

	/**
		return 0 for success
	*/
	int		OnAfterResetNLFit();

	/**
		combination of NLFITDIRTY
	*/
	int		GetNLFitDirtyStatus();

	void	SetNumDatasets(int nNumSets);

	/**
		only works for NLPMGRTYPE_MULTIPLE_SETS
	*/
	void	SetActiveDataset(int nSet);

	int		GetDerivedParameters(int nSetIndex, int nPeakIndex, StringArray *pvsNames, vector *pvValues = NULL);

	/**
	Remark:
		  Control LCL and UCL cloumns display in parameters grid

	Parameters:
		nMethod=[input]method to compute confidence limits, -1 means no computation,
				otherwise enumerated as CONF_LIMIT_METHOD_AS_BASED, CONF_LIMIT_METHOD_MODLE_COMP_BASED, etc
	*/
	void	SetComputeConfLimitsMethod(int nMethod = -1);

	int		GetAllParameterNames(StringArray& arrNames, bool bTrimPostfix = false);

	/**
	Parameters:
		nRow=[input]row index to get, 0 offset
		paramRow=[output]get all input numeric parameter settings as ParameterRow
	Return:
		0 for success
	*/
	int		GetRow(ParameterRow& paramRow, int nRow);

	/**
	Parameters:
		nEditColType=[input]enumerated as NLPARAMGRIDCOLTYPE
		lpcszNamePrefix=[input]parameter name prefix to match
		rValue=[input]value to set
		nOptionSetBounds=[input]choices to set bounds value :
		NLPARAMETER_BOUNDS_SET_BY_CONSTANT : directly apply rValue
		NLPARAMETER_BOUNDS_SET_BY_RELATIVE_OFFSET : add/minus (rValue)percentage of current parameter value
		NLPARAMETER_BOUNDS_SET_BY_ABSOLUTE_OFFSET : add/minus rValue

		pvnRowIndicesToSkip=[input]row indices to skip parameter setting

	Return:
		Update bits as NLDLGPART, the same as OnEdit
	*/
	int		SetParameters(NLPARAMGRIDCOLTYPE nEditColType, LPCSTR lpcszNamePrefix, double rValue, int nOptionSetBounds = NLPARAMETER_BOUNDS_SET_BY_CONSTANT, vector<int>* pvnRowIndicesToSkip = NULL);

	/**
		This function only works for multiple funcions peak fitting, like PA
	*/
	/// **********************************************************

	void	SetBaselineFittingWithPeaks(BOOL bFitWithPeaks);
	BOOL	GetBaselineFittingWithPeaks();

	/**
		All the three functions below will set/get fixed or shared status of specific parameters.
	*/

	/// when bSet = false, bFixed will be true if baseline parameter or whole baseline peak is fixed.
	int		FixBaseline(bool *pbFixed, BOOL bSet = TRUE);

	/// when bSet = false, bFixed will be true if any center/width of the first peak(except for the baseline) is fixed.
	int		FixPeaksCenterAndWidth(bool *pbFixed, BOOL bCenter, BOOL bSet = TRUE);

	/// when bSet = false, bShared will be true if any width of the first peak(except for the baseline) is shared.
	int		SharePeaksWidth(bool *pbShared, BOOL bSet = TRUE);

	/// **********************************************************

	//------ Folger 11/04/08 QA80-12509 v8.0965 SUPPORT_BOTH_PEAKS_SORTING_AND_REORDERING_FOR_MULTIPLE_PEAKS_FITTING
	int		MultiplePeaksSortingByParameter(NLPARAMETERSORTING nSortedBy, BOOL bAscending = TRUE);

	int		MultiplePeaksReordering(vector<uint> *pvnIndices = NULL);
	//------ End SUPPORT_BOTH_PEAKS_SORTING_AND_REORDERING_FOR_MULTIPLE_PEAKS_FITTING

	//------ Folger 12/08/08 QA80-12730 v8.0983b SUPPORT_GET_TOTAL_GROUP_INDICES_AND_GET_PARAM_INDICES_BY_GROUP_INDEX
	/// both functions below are for multiple peaks fitting
	int		GetGroupIndices(vector<int>& vnIndices);
	int		GetParamIndicesByGroupIndex(vector<int>& vnIndices, int nGroupIndex);
	//------

	///------ Folger 12/16/08 QA80-10499 v8.0987b SUUPORT_MULTI_SETS_PARAM_MANAGER_INITIALIZED_BY_OBJECT_COPY
	/// this method only works for NLPMGRTYPE_MULTIPLE_SETS
	/// no need for now, maybe later ...
	//BOOL	InitMultiSetsParams(NLParametersManager &mngr);
	///------ End SUUPORT_MULTI_SETS_PARAM_MANAGER_INITIALIZED_BY_OBJECT_COPY

	///------ Folger 03/17/09 QA80-13290 PARAMETERS_GRID_SUPPORT_COPY_AND_PASTE_ALL_VALUES_DEPEND_ON_BASED_NAME
	/**
	Parameters:
		col = [input] for now(SR5) it supports only NLPARAMGRIDCOLTYPE_VALUE, NLPARAMGRIDCOLTYPE_LB, NLPARAMGRIDCOLTYPE_UB.
		lpcszBaseParamName = [input] parameter based name, for example, "xc" stands for "xc", "xc__2", "xc__3" etc. NULL or empty string to match all
	Return:
		Number of values have been copied if successful, otherwise return -1.
	*/
	///------ Folger 07/12/10 ORG-515-P1 COPY_PASTE_WHOLE_COLUMN_IN_NLFIT_SHOULD_ONLY_HANDLE_VISIBLE
	//int    CopyToClipboard(NLPARAMGRIDCOLTYPE col, LPCSTR lpcszBaseParamName);
	int    CopyToClipboard(NLPARAMGRIDCOLTYPE col, LPCSTR lpcszBaseParamName, vector<int>* pvnIndices = NULL);
	///------ End COPY_PASTE_WHOLE_COLUMN_IN_NLFIT_SHOULD_ONLY_HANDLE_VISIBLE
	
	
	/**
	Parameters:
		col=[input] the same as CopyToClipboard => col
		lpcszBaseParamName = [input] the same as CopyToClipboard => lpcszBaseParamName
	Return:
		Update bits as NLDLGPART if successful, otherwise return -1.
	*/
	///------ Folger 07/12/10 ORG-515-P1 COPY_PASTE_WHOLE_COLUMN_IN_NLFIT_SHOULD_ONLY_HANDLE_VISIBLE
	//int    PasteFromClipboard(NLPARAMGRIDCOLTYPE col, LPCSTR lpcszBaseParamName);
	int    PasteFromClipboard(NLPARAMGRIDCOLTYPE col, LPCSTR lpcszBaseParamName, vector<int>* pvnIndices = NULL);
	///------ End COPY_PASTE_WHOLE_COLUMN_IN_NLFIT_SHOULD_ONLY_HANDLE_VISIBLE
	///------ End PARAMETERS_GRID_SUPPORT_COPY_AND_PASTE_ALL_VALUES_DEPEND_ON_BASED_NAME

	///------ Folger 06/18/09 CENTRALIZE_CODE_ABOUT_GETTING_PEAK_FUNC_PARAM_INDICES
	int		GetPeaksParamValuesByCharacteristic(vector& vValues, NLPARAMETERGETTING nGetBy);
	///------ End CENTRALIZE_CODE_ABOUT_GETTING_PEAK_FUNC_PARAM_INDICES
};


#endif		// !_MSC_VER



//////////////////////////////////////////////////////
//////////////////////////////////////////////////////
//////////////////////////////////////////////////////
//////////////////////////////////////////////////////
#endif		// __NLPARAMS_H__

